<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Clinic extends Model 
{

    protected $table = 'clinics';
    public $timestamps = true;
    protected $fillable = array('branch_id', 'name');

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function doctors()
    {
        return $this->belongsToMany('Doctor');
    }

    public function appointments()
    {
        return $this->hasMany('Appointment', 'clinic_id');
    }

}